//************************************************************************************
//**  
//**  Source name:   C:\Users\Delphine\Desktop\ANTONY\6 - TP\Flowcode\buggy\buggy labyrinteV6\source fonctionnelle et comente\laby.fcfx
//**  Title:         
//**  Description:   
//**  Device:        PIC.18F.Formula Flowcode Buggy
//**  
//**  Generated by:  Flowcode v6.1.0.0
//**  Date:          Friday, November 14, 2014 09:14:40
//**  Users:         10
//**  Registered to: Multipower
//**  Licence key:   98KY5B
//**  
//**  
//**  http://www.matrixtsl.com
//**  
//************************************************************************************


#define MX_PIC

#define MX_CAL_PIC

#define MX_CLK_SPEED 48000000

#define FCP_NULL Unconnected_Port


#include <system.h>
#pragma DATA 0x300000, 0x20
#pragma DATA 0x300001, 0xe
#pragma DATA 0x300002, 0x3e
#pragma DATA 0x300003, 0x1e
#pragma DATA 0x300004, 0x0
#pragma DATA 0x300005, 0x81
#pragma DATA 0x300006, 0x81
#pragma DATA 0x300007, 0x0
#pragma DATA 0x300008, 0xf
#pragma DATA 0x300009, 0x80
#pragma DATA 0x30000a, 0xf
#pragma DATA 0x30000b, 0xa0
#pragma DATA 0x30000c, 0xf
#pragma DATA 0x30000d, 0x0


/*========================================================================*\
   Use :Inclure les dfinitions de type
\*========================================================================*/
#include "C:\Program Files\Flowcode 6\CAL\internals.c"



/*========================================================================*\
   Use :panel
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
#define FCV_FALSE (0)
#define FCV_VIT (175)
#define FCV_TRUE (1)
MX_GLOBAL MX_UINT16 FCV_RIGHT = (0x0);
MX_GLOBAL MX_UINT16 FCV_LEFT = (0x0);
MX_GLOBAL MX_UINT16 FCV_FRONT = (0x0);
MX_GLOBAL MX_UINT8 FCV_VITESSE;
MX_GLOBAL MX_UINT8 FCV_COMPR;
MX_GLOBAL MX_UINT8 FCV_COMPL;

void FCM_lire_capteurs_IR();
void FCM_degagerment();
void FCM_init();
void FCM_marche_libre();
void FCM_eteindre_LEDs();

/*========================================================================*\
   Use :ButtonCtrl
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/

/*========================================================================*\
   Use :switch_base
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
MX_UINT8 FCD_05262_switch_base__ReadState();
void FCD_05262_switch_base__WaitUntilHigh();
void FCD_05262_switch_base__WaitUntilLow();

/*========================================================================*\
   Use :switch2
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
#define FCD_08272_switch2__ReadState FCD_05262_switch_base__ReadState
#define FCD_08272_switch2__WaitUntilHigh FCD_05262_switch_base__WaitUntilHigh
#define FCD_08272_switch2__WaitUntilLow FCD_05262_switch_base__WaitUntilLow

/*========================================================================*\
   Use :ButtonCtrl
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/

/*========================================================================*\
   Use :switch_base
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
MX_UINT8 FCD_05261_switch_base__ReadState();
void FCD_05261_switch_base__WaitUntilHigh();
void FCD_05261_switch_base__WaitUntilLow();

/*========================================================================*\
   Use :switch1
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
#define FCD_08271_switch1__ReadState FCD_05261_switch_base__ReadState
#define FCD_08271_switch1__WaitUntilHigh FCD_05261_switch_base__WaitUntilHigh
#define FCD_08271_switch1__WaitUntilLow FCD_05261_switch_base__WaitUntilLow

/*========================================================================*\
   Use :led_base
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
void FCD_03d98_led_base__TurnOn();
void FCD_03d98_led_base__TurnOff();

/*========================================================================*\
   Use :led8
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
#define FCD_06ab8_led8__TurnOn FCD_03d98_led_base__TurnOn
#define FCD_06ab8_led8__TurnOff FCD_03d98_led_base__TurnOff

/*========================================================================*\
   Use :led_base
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
void FCD_03d97_led_base__TurnOn();
void FCD_03d97_led_base__TurnOff();

/*========================================================================*\
   Use :led7
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
#define FCD_06ab7_led7__TurnOn FCD_03d97_led_base__TurnOn
#define FCD_06ab7_led7__TurnOff FCD_03d97_led_base__TurnOff

/*========================================================================*\
   Use :led_base
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
void FCD_03d96_led_base__TurnOn();
void FCD_03d96_led_base__TurnOff();

/*========================================================================*\
   Use :led6
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
#define FCD_06ab6_led6__TurnOn FCD_03d96_led_base__TurnOn
#define FCD_06ab6_led6__TurnOff FCD_03d96_led_base__TurnOff

/*========================================================================*\
   Use :led_base
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
void FCD_03d95_led_base__TurnOn();
void FCD_03d95_led_base__TurnOff();

/*========================================================================*\
   Use :led5
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
#define FCD_06ab5_led5__TurnOn FCD_03d95_led_base__TurnOn
#define FCD_06ab5_led5__TurnOff FCD_03d95_led_base__TurnOff

/*========================================================================*\
   Use :led_base
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
void FCD_03d94_led_base__TurnOn();
void FCD_03d94_led_base__TurnOff();

/*========================================================================*\
   Use :led4
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
#define FCD_06ab4_led4__TurnOn FCD_03d94_led_base__TurnOn
#define FCD_06ab4_led4__TurnOff FCD_03d94_led_base__TurnOff

/*========================================================================*\
   Use :led_base
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
void FCD_03d93_led_base__TurnOn();
void FCD_03d93_led_base__TurnOff();

/*========================================================================*\
   Use :led3
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
#define FCD_06ab3_led3__TurnOn FCD_03d93_led_base__TurnOn
#define FCD_06ab3_led3__TurnOff FCD_03d93_led_base__TurnOff

/*========================================================================*\
   Use :led_base
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
void FCD_03d92_led_base__TurnOn();
void FCD_03d92_led_base__TurnOff();

/*========================================================================*\
   Use :led2
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
#define FCD_06ab2_led2__TurnOn FCD_03d92_led_base__TurnOn
#define FCD_06ab2_led2__TurnOff FCD_03d92_led_base__TurnOff

/*========================================================================*\
   Use :led_base
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
void FCD_03d91_led_base__TurnOn();
void FCD_03d91_led_base__TurnOff();

/*========================================================================*\
   Use :led1
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
#define FCD_06ab1_led1__TurnOn FCD_03d91_led_base__TurnOn
#define FCD_06ab1_led1__TurnOff FCD_03d91_led_base__TurnOff

/*========================================================================*\
   Use :FormulaFlowcode1
       :Dclarations des variables
       :Dclarations de la fonction macro
\*========================================================================*/
#define FCV_09c91_FormulaFlowcode1__ADC_IRR (4)
#define FCV_09c91_FormulaFlowcode1__ADC_LDR (9)
#define FCV_09c91_FormulaFlowcode1__ADC_IRL (1)
#define FCV_09c91_FormulaFlowcode1__ADC_IRF (3)
#define FCV_09c91_FormulaFlowcode1__ADC_MIC (8)

void FCD_09c91_FormulaFlowcode1__PlayNote(MX_UINT8 FCL_NOTE, MX_UINT16 FCL_DELAY_MS);
void FCD_09c91_FormulaFlowcode1__LEDOn(MX_UINT8 FCL_LED);
void FCD_09c91_FormulaFlowcode1__FF_SampleADC(MX_UINT8 FCL_CHANNEL);
void FCD_09c91_FormulaFlowcode1__Stop();
void FCD_09c91_FormulaFlowcode1__LEDOff(MX_UINT8 FCL_LED);
MX_SINT16 FCD_09c91_FormulaFlowcode1__ReadMic();
MX_UINT8 FCD_09c91_FormulaFlowcode1__ReadSwitch(MX_UINT8 FCL_SWITCH);
void FCD_09c91_FormulaFlowcode1__SpinLeft(MX_UINT8 FCL_POWER);
void FCD_09c91_FormulaFlowcode1__Forward(MX_UINT8 FCL_POWER);
MX_UINT8 FCD_09c91_FormulaFlowcode1__ReadLineSensor(MX_UINT8 FCL_SENSOR);
void FCD_09c91_FormulaFlowcode1__SpinRight(MX_UINT8 FCL_POWER);
MX_UINT8 FCD_09c91_FormulaFlowcode1__CheckIR(MX_UINT8 FCL_SENSOR);
MX_UINT16 FCD_09c91_FormulaFlowcode1__FF_ReadADC();
MX_UINT16 FCD_09c91_FormulaFlowcode1__ReadIRSensor(MX_UINT8 FCL_SENSOR);
void FCD_09c91_FormulaFlowcode1__SetMotors(MX_SINT16 FCL_LEFT_POWER, MX_SINT16 FCL_RIGHT_POWER);
void FCD_09c91_FormulaFlowcode1__Reverse(MX_UINT8 FCL_POWER);
void FCD_09c91_FormulaFlowcode1__WaitForSwitch(MX_UINT8 FCL_SWITCH);
MX_SINT16 FCD_09c91_FormulaFlowcode1__ReadLDR();
void FCD_09c91_FormulaFlowcode1__FF_SetDutyCycle(MX_UINT8 FCL_DUTYL, MX_UINT8 FCL_DUTYR);
void FCD_09c91_FormulaFlowcode1__WriteLEDs(MX_UINT8 FCL_LED_BYTE);
void FCD_09c91_FormulaFlowcode1__Initialise();

/*========================================================================*\
   Use :Inclure la couche d'adaptation de puce
\*========================================================================*/
#include "C:\Program Files\Flowcode 6\CAL\includes.c"


/*========================================================================*\
   Use :ButtonCtrl
       :Implmentations de la macro
\*========================================================================*/

/*========================================================================*\
   Use :switch_base
       :Implmentations de la macro
\*========================================================================*/
/*=----------------------------------------------------------------------=*\
   Use :Reads the button state as 0 for released or 1 for pressed

       :Performs debounce if required
       :
       :Renvoie : MX_UINT8
\*=----------------------------------------------------------------------=*/
MX_UINT8 FCD_05262_switch_base__ReadState()
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_SWITCHVAL = (0xff); // Value of the press
	MX_UINT16 FCL_DEL_COUNT;
	MX_UINT8 FCL_OLD_SWITCHVAL;
	MX_UINT8 FCR_RETVAL;


	if (0 != FCP_GET(B, B, 0x10, 0x4))
	{

		FCR_RETVAL = 1;

	} else {

		FCR_RETVAL = 0;

	}

	#if (0) // 0 > 0

	//Le code a t optimis par le prprocesseur
	// #else

	#endif

	return (FCR_RETVAL);

}

/*=----------------------------------------------------------------------=*\
   Use :Waits until the switch is in state 'high'

       :The interpretation of 'high' depends on the polarity
\*=----------------------------------------------------------------------=*/
void FCD_05262_switch_base__WaitUntilHigh()
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_SWITCHVAL = (0xff); // The state of the pin
	MX_UINT16 FCL_DEL_COUNT;
	MX_UINT8 FCL_OLD_SWITCHVAL;


	while (1)
	{

		FCL_SWITCHVAL = FCP_GET(B, B, 0x10, 0x4);

		#if (0) // 0 == 1

		//Le code a t optimis par le prprocesseur
		// #else

		#endif

		#if (0) // 0 > 0

		//Le code a t optimis par le prprocesseur
		// #else

		#endif


		if ((FCL_SWITCHVAL == 0) == 0) break;
	}

}

/*=----------------------------------------------------------------------=*\
   Use :Waits until the switch is in state 'low'

       :The interpretation of 'high' depends on the polarity
\*=----------------------------------------------------------------------=*/
void FCD_05262_switch_base__WaitUntilLow()
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_SWITCHVAL; // The state of the pin
	MX_UINT16 FCL_DEL_COUNT;
	MX_UINT8 FCL_OLD_SWITCHVAL;


	while (1)
	{

		FCL_SWITCHVAL = FCP_GET(B, B, 0x10, 0x4);

		#if (0) // 0 == 1

		//Le code a t optimis par le prprocesseur
		// #else

		#endif

		#if (0) // 0 > 0

		//Le code a t optimis par le prprocesseur
		// #else

		#endif


		if ((FCL_SWITCHVAL != 0) == 0) break;
	}

}


/*========================================================================*\
   Use :switch2
       :Implmentations de la macro
\*========================================================================*/

/*========================================================================*\
   Use :ButtonCtrl
       :Implmentations de la macro
\*========================================================================*/

/*========================================================================*\
   Use :switch_base
       :Implmentations de la macro
\*========================================================================*/
/*=----------------------------------------------------------------------=*\
   Use :Reads the button state as 0 for released or 1 for pressed

       :Performs debounce if required
       :
       :Renvoie : MX_UINT8
\*=----------------------------------------------------------------------=*/
MX_UINT8 FCD_05261_switch_base__ReadState()
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_SWITCHVAL = (0xff); // Value of the press
	MX_UINT16 FCL_DEL_COUNT;
	MX_UINT8 FCL_OLD_SWITCHVAL;
	MX_UINT8 FCR_RETVAL;


	if (0 != FCP_GET(B, B, 0x20, 0x5))
	{

		FCR_RETVAL = 1;

	} else {

		FCR_RETVAL = 0;

	}

	#if (0) // 0 > 0

	//Le code a t optimis par le prprocesseur
	// #else

	#endif

	return (FCR_RETVAL);

}

/*=----------------------------------------------------------------------=*\
   Use :Waits until the switch is in state 'high'

       :The interpretation of 'high' depends on the polarity
\*=----------------------------------------------------------------------=*/
void FCD_05261_switch_base__WaitUntilHigh()
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_SWITCHVAL = (0xff); // The state of the pin
	MX_UINT16 FCL_DEL_COUNT;
	MX_UINT8 FCL_OLD_SWITCHVAL;


	while (1)
	{

		FCL_SWITCHVAL = FCP_GET(B, B, 0x20, 0x5);

		#if (0) // 0 == 1

		//Le code a t optimis par le prprocesseur
		// #else

		#endif

		#if (0) // 0 > 0

		//Le code a t optimis par le prprocesseur
		// #else

		#endif


		if ((FCL_SWITCHVAL == 0) == 0) break;
	}

}

/*=----------------------------------------------------------------------=*\
   Use :Waits until the switch is in state 'low'

       :The interpretation of 'high' depends on the polarity
\*=----------------------------------------------------------------------=*/
void FCD_05261_switch_base__WaitUntilLow()
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_SWITCHVAL; // The state of the pin
	MX_UINT16 FCL_DEL_COUNT;
	MX_UINT8 FCL_OLD_SWITCHVAL;


	while (1)
	{

		FCL_SWITCHVAL = FCP_GET(B, B, 0x20, 0x5);

		#if (0) // 0 == 1

		//Le code a t optimis par le prprocesseur
		// #else

		#endif

		#if (0) // 0 > 0

		//Le code a t optimis par le prprocesseur
		// #else

		#endif


		if ((FCL_SWITCHVAL != 0) == 0) break;
	}

}


/*========================================================================*\
   Use :switch1
       :Implmentations de la macro
\*========================================================================*/

/*========================================================================*\
   Use :led_base
       :Implmentations de la macro
\*========================================================================*/
/*=----------------------------------------------------------------------=*\
   Use :Turn the LED off.
\*=----------------------------------------------------------------------=*/
void FCD_03d98_led_base__TurnOn()
{

	FCP_SET(B, D, 0x1, 0x0, 1);

}

/*=----------------------------------------------------------------------=*\
   Use :Turn the LED on.
\*=----------------------------------------------------------------------=*/
void FCD_03d98_led_base__TurnOff()
{

	FCP_SET(B, D, 0x1, 0x0, 1 - 1);

}


/*========================================================================*\
   Use :led8
       :Implmentations de la macro
\*========================================================================*/

/*========================================================================*\
   Use :led_base
       :Implmentations de la macro
\*========================================================================*/
/*=----------------------------------------------------------------------=*\
   Use :Turn the LED off.
\*=----------------------------------------------------------------------=*/
void FCD_03d97_led_base__TurnOn()
{

	FCP_SET(B, D, 0x2, 0x1, 1);

}

/*=----------------------------------------------------------------------=*\
   Use :Turn the LED on.
\*=----------------------------------------------------------------------=*/
void FCD_03d97_led_base__TurnOff()
{

	FCP_SET(B, D, 0x2, 0x1, 1 - 1);

}


/*========================================================================*\
   Use :led7
       :Implmentations de la macro
\*========================================================================*/

/*========================================================================*\
   Use :led_base
       :Implmentations de la macro
\*========================================================================*/
/*=----------------------------------------------------------------------=*\
   Use :Turn the LED off.
\*=----------------------------------------------------------------------=*/
void FCD_03d96_led_base__TurnOn()
{

	FCP_SET(B, D, 0x4, 0x2, 1);

}

/*=----------------------------------------------------------------------=*\
   Use :Turn the LED on.
\*=----------------------------------------------------------------------=*/
void FCD_03d96_led_base__TurnOff()
{

	FCP_SET(B, D, 0x4, 0x2, 1 - 1);

}


/*========================================================================*\
   Use :led6
       :Implmentations de la macro
\*========================================================================*/

/*========================================================================*\
   Use :led_base
       :Implmentations de la macro
\*========================================================================*/
/*=----------------------------------------------------------------------=*\
   Use :Turn the LED off.
\*=----------------------------------------------------------------------=*/
void FCD_03d95_led_base__TurnOn()
{

	FCP_SET(B, D, 0x8, 0x3, 1);

}

/*=----------------------------------------------------------------------=*\
   Use :Turn the LED on.
\*=----------------------------------------------------------------------=*/
void FCD_03d95_led_base__TurnOff()
{

	FCP_SET(B, D, 0x8, 0x3, 1 - 1);

}


/*========================================================================*\
   Use :led5
       :Implmentations de la macro
\*========================================================================*/

/*========================================================================*\
   Use :led_base
       :Implmentations de la macro
\*========================================================================*/
/*=----------------------------------------------------------------------=*\
   Use :Turn the LED off.
\*=----------------------------------------------------------------------=*/
void FCD_03d94_led_base__TurnOn()
{

	FCP_SET(B, D, 0x10, 0x4, 1);

}

/*=----------------------------------------------------------------------=*\
   Use :Turn the LED on.
\*=----------------------------------------------------------------------=*/
void FCD_03d94_led_base__TurnOff()
{

	FCP_SET(B, D, 0x10, 0x4, 1 - 1);

}


/*========================================================================*\
   Use :led4
       :Implmentations de la macro
\*========================================================================*/

/*========================================================================*\
   Use :led_base
       :Implmentations de la macro
\*========================================================================*/
/*=----------------------------------------------------------------------=*\
   Use :Turn the LED off.
\*=----------------------------------------------------------------------=*/
void FCD_03d93_led_base__TurnOn()
{

	FCP_SET(B, D, 0x20, 0x5, 1);

}

/*=----------------------------------------------------------------------=*\
   Use :Turn the LED on.
\*=----------------------------------------------------------------------=*/
void FCD_03d93_led_base__TurnOff()
{

	FCP_SET(B, D, 0x20, 0x5, 1 - 1);

}


/*========================================================================*\
   Use :led3
       :Implmentations de la macro
\*========================================================================*/

/*========================================================================*\
   Use :led_base
       :Implmentations de la macro
\*========================================================================*/
/*=----------------------------------------------------------------------=*\
   Use :Turn the LED off.
\*=----------------------------------------------------------------------=*/
void FCD_03d92_led_base__TurnOn()
{

	FCP_SET(B, D, 0x40, 0x6, 1);

}

/*=----------------------------------------------------------------------=*\
   Use :Turn the LED on.
\*=----------------------------------------------------------------------=*/
void FCD_03d92_led_base__TurnOff()
{

	FCP_SET(B, D, 0x40, 0x6, 1 - 1);

}


/*========================================================================*\
   Use :led2
       :Implmentations de la macro
\*========================================================================*/

/*========================================================================*\
   Use :led_base
       :Implmentations de la macro
\*========================================================================*/
/*=----------------------------------------------------------------------=*\
   Use :Turn the LED off.
\*=----------------------------------------------------------------------=*/
void FCD_03d91_led_base__TurnOn()
{

	FCP_SET(B, D, 0x80, 0x7, 1);

}

/*=----------------------------------------------------------------------=*\
   Use :Turn the LED on.
\*=----------------------------------------------------------------------=*/
void FCD_03d91_led_base__TurnOff()
{

	FCP_SET(B, D, 0x80, 0x7, 1 - 1);

}


/*========================================================================*\
   Use :led1
       :Implmentations de la macro
\*========================================================================*/

/*========================================================================*\
   Use :FormulaFlowcode1
       :Implmentations de la macro
\*========================================================================*/
/*=----------------------------------------------------------------------=*\
   Use :Outputs a single tone from the onboard speaker for the period specified
       :
       :Param??tres pour la macro PlayNote :
       :  Note : MX_UINT8
       :  Delay_ms : MX_UINT16
\*=----------------------------------------------------------------------=*/
void FCD_09c91_FormulaFlowcode1__PlayNote(MX_UINT8 FCL_NOTE, MX_UINT16 FCL_DELAY_MS)
{
	//Dfinitions des variables locales
	MX_UINT16 FCL_INV_NOTE;
	MX_UINT16 FCL_DELAYUS;
	MX_UINT16 FCL_DELAYMS;
	MX_UINT16 FCL_LOOP = (0x0);


	FCL_INV_NOTE = 255 - FCL_NOTE;
	FCL_DELAYUS = (20 * FCL_INV_NOTE);
	FCL_DELAYMS = FCL_DELAYUS / 1000;

	if (FCL_DELAYMS == 0)
	{

		FCL_DELAYMS = 1;

	// } else {

	}

	#if 0 // Disabled code
	trisc = trisc & 0xFE;

	#endif // #if 0: Disabled code
	FCP_SET(B, C, 0x1, 0x0, 0);

	FCL_INV_NOTE = 10 * FCL_INV_NOTE;

	while ((FCL_LOOP * FCL_DELAYMS) < FCL_DELAY_MS)
	{

		FCI_DELAYINT_US(FCL_INV_NOTE);

		FCP_SET(B, C, 0x1, 0x0, 1);

		FCI_DELAYINT_US(FCL_INV_NOTE);

		FCP_SET(B, C, 0x1, 0x0, 0);

		FCL_LOOP = FCL_LOOP + 1;


	}

}

/*=----------------------------------------------------------------------=*\
   Use :Switches on a single LED on the front of the Formula Flowcode.
       :
       :Param??tres pour la macro LEDOn :
       :  LED : MX_UINT8
\*=----------------------------------------------------------------------=*/
void FCD_09c91_FormulaFlowcode1__LEDOn(MX_UINT8 FCL_LED)
{

	FCP_SET(F, D, 0xff, 0x0, FCP_GET(F, D, 0xff, 0x0) | (1 << FCL_LED));

}

/*=----------------------------------------------------------------------=*\
   Use :Param??tres pour la macro FF_SampleADC :
       :  Channel : MX_UINT8
\*=----------------------------------------------------------------------=*/
void FCD_09c91_FormulaFlowcode1__FF_SampleADC(MX_UINT8 FCL_CHANNEL)
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_CNT = (0x0);


	adcon1 = 0x00;

	adcon2 = 0x03;

	adcon0 = 0x01 | (FCL_CHANNEL << 2);



	while (FCL_CNT < 100)
	{

		FCL_CNT = FCL_CNT + 1;


	}

	adcon0 = adcon0 | 0x02;

	while (adcon0 & 0x02) ;

	adcon1 = 0x0f;

	adcon0 = 0x00;

}

/*=----------------------------------------------------------------------=*\
   Use :Stops both motors
\*=----------------------------------------------------------------------=*/
void FCD_09c91_FormulaFlowcode1__Stop()
{

	trise = trise & 0xFC;

	porte = porte & 0xFC;

	FCD_09c91_FormulaFlowcode1__FF_SetDutyCycle(0, 0);

}

/*=----------------------------------------------------------------------=*\
   Use :Switches off a single LED on the front of the Formula Flowcode.
       :
       :Param??tres pour la macro LEDOff :
       :  LED : MX_UINT8
\*=----------------------------------------------------------------------=*/
void FCD_09c91_FormulaFlowcode1__LEDOff(MX_UINT8 FCL_LED)
{

	FCP_SET(F, D, 0xff, 0x0, FCP_GET(F, D, 0xff, 0x0) & ~(1 << FCL_LED));

}

/*=----------------------------------------------------------------------=*\
   Use :Reads the current audio signal level from the on-board microphone.
       :
       :Renvoie : MX_SINT16
\*=----------------------------------------------------------------------=*/
MX_SINT16 FCD_09c91_FormulaFlowcode1__ReadMic()
{
	//Dfinitions des variables locales
	MX_SINT16 FCR_RETVAL;


	trisb = trisb | 0x04;

	FCD_09c91_FormulaFlowcode1__FF_SampleADC(FCV_09c91_FormulaFlowcode1__ADC_MIC);

	FCR_RETVAL = FCD_09c91_FormulaFlowcode1__FF_ReadADC();

	return (FCR_RETVAL);

}

/*=----------------------------------------------------------------------=*\
   Use :Reads the value of one of the switches from the front of the Formula Flowcode.
       :
       :Param??tres pour la macro ReadSwitch :
       :  Switch : MX_UINT8
       :
       :Renvoie : MX_UINT8
\*=----------------------------------------------------------------------=*/
MX_UINT8 FCD_09c91_FormulaFlowcode1__ReadSwitch(MX_UINT8 FCL_SWITCH)
{
	//Dfinitions des variables locales
	MX_UINT8 FCR_RETVAL;


	if ((FCL_SWITCH == 0) || (FCL_SWITCH == 'l') || (FCL_SWITCH == 'L'))
	{

		FCR_RETVAL = FCP_GET(B, B, 0x20, 0x5);

	} else {

		FCR_RETVAL = FCP_GET(B, B, 0x10, 0x4);

	}

	return (FCR_RETVAL);

}

/*=----------------------------------------------------------------------=*\
   Use :Spins the formula flowcode on the spot in an anticlockwise direction as seen from above.
       :
       :Param??tres pour la macro SpinLeft :
       :  Power : MX_UINT8
\*=----------------------------------------------------------------------=*/
void FCD_09c91_FormulaFlowcode1__SpinLeft(MX_UINT8 FCL_POWER)
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_MOTOR_LEFT;
	MX_UINT8 FCL_MOTOR_RIGHT;
	MX_UINT8 FCL_SCALEFACTOR;
	MX_UINT16 FCL_SCALEVAL;


	trise = trise & 0xFC;

	porte = porte & 0xFC;

	#if (0) // 0 < 0

	//Le code a t optimis par le prprocesseur
	#else

		FCL_MOTOR_LEFT = FCL_POWER;

	#endif

	#if (0) // 0 > 0

	//Le code a t optimis par le prprocesseur
	#else

		FCL_MOTOR_RIGHT = 255 - FCL_POWER;

	#endif

	FCP_SET(B, E, 0x2, 0x1, 1);

	FCD_09c91_FormulaFlowcode1__FF_SetDutyCycle(FCL_MOTOR_RIGHT, FCL_MOTOR_LEFT);

}

/*=----------------------------------------------------------------------=*\
   Use :Drives both motors of the formula flowcode forwards with the power specified.
       :
       :Param??tres pour la macro Forward :
       :  Power : MX_UINT8
\*=----------------------------------------------------------------------=*/
void FCD_09c91_FormulaFlowcode1__Forward(MX_UINT8 FCL_POWER)
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_POWER_L;
	MX_UINT8 FCL_POWER_R;
	MX_UINT8 FCL_SCALEFACTOR;
	MX_UINT16 FCL_SCALEVAL;


	trise = trise & 0xFC;

	porte = porte | 0x03;

	#if (0) // 0 < 0

	//Le code a t optimis par le prprocesseur
	#else

		FCL_POWER_L = FCL_POWER;

	#endif

	#if (0) // 0 > 0

	//Le code a t optimis par le prprocesseur
	#else

		FCL_POWER_R = FCL_POWER;

	#endif

	FCD_09c91_FormulaFlowcode1__FF_SetDutyCycle(255 - FCL_POWER_L, 255 - FCL_POWER_R);

}

/*=----------------------------------------------------------------------=*\
   Use :Returns the digital value from the line sensor specified.
       :
       :Param??tres pour la macro ReadLineSensor :
       :  Sensor : MX_UINT8
       :
       :Renvoie : MX_UINT8
\*=----------------------------------------------------------------------=*/
MX_UINT8 FCD_09c91_FormulaFlowcode1__ReadLineSensor(MX_UINT8 FCL_SENSOR)
{
	//Dfinitions des variables locales
	MX_UINT8 FCR_RETVAL;


	FCR_RETVAL = 0;

	trisb = trisb | 0x03;

	if ((FCL_SENSOR == 0) || (FCL_SENSOR == 'l') || (FCL_SENSOR == 'L'))
	{

		if (FCP_GET(B, B, 0x2, 0x1))
		{

			FCR_RETVAL = 1;

		// } else {

		}

	// } else {

	}

	if ((FCL_SENSOR == 1) || (FCL_SENSOR == 'r') || (FCL_SENSOR == 'R'))
	{

		if (FCP_GET(B, B, 0x1, 0x0))
		{

			FCR_RETVAL = 1;

		// } else {

		}

	// } else {

	}

	return (FCR_RETVAL);

}

/*=----------------------------------------------------------------------=*\
   Use :Spins the formula flowcode on the spot in a clockwise direction as seen from above.
       :
       :Param??tres pour la macro SpinRight :
       :  Power : MX_UINT8
\*=----------------------------------------------------------------------=*/
void FCD_09c91_FormulaFlowcode1__SpinRight(MX_UINT8 FCL_POWER)
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_MOTOR_LEFT;
	MX_UINT8 FCL_MOTOR_RIGHT;
	MX_UINT8 FCL_SCALEFACTOR;
	MX_UINT16 FCL_SCALEVAL;


	trise = trise & 0xFC;

	porte = porte & 0xFC;

	#if (0) // 0 < 0

	//Le code a t optimis par le prprocesseur
	#else

		FCL_MOTOR_LEFT = 255 - FCL_POWER;

	#endif

	#if (0) // 0 > 0

	//Le code a t optimis par le prprocesseur
	#else

		FCL_MOTOR_RIGHT = FCL_POWER;

	#endif

	FCP_SET(B, E, 0x1, 0x0, 1);

	FCD_09c91_FormulaFlowcode1__FF_SetDutyCycle(FCL_MOTOR_RIGHT, FCL_MOTOR_LEFT);

}

/*=----------------------------------------------------------------------=*\
   Use :Checks to see if a IR sensor is within the master threshold distance.
       :
       :Param??tres pour la macro CheckIR :
       :  Sensor : MX_UINT8
       :
       :Renvoie : MX_UINT8
\*=----------------------------------------------------------------------=*/
MX_UINT8 FCD_09c91_FormulaFlowcode1__CheckIR(MX_UINT8 FCL_SENSOR)
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_FOUND = (0x0);
	MX_UINT16 FCL_THRESH;
	MX_UINT8 FCR_RETVAL;


	porta = 0x00;

	trisa = 0x2A;

	if ((FCL_SENSOR == 0) || (FCL_SENSOR == 'l') || (FCL_SENSOR == 'L'))
	{

		FCL_FOUND = 1;

		FCP_SET(B, A, 0x1, 0x0, 1);

		FCI_DELAYBYTE_US(10);

		FCD_09c91_FormulaFlowcode1__FF_SampleADC(FCV_09c91_FormulaFlowcode1__ADC_IRL);

		FCP_SET(B, A, 0x1, 0x0, 0);

		FCL_THRESH = 100;

	// } else {

	}

	if ((FCL_SENSOR == 1) || (FCL_SENSOR == 'f') || (FCL_SENSOR == 'F'))
	{

		FCL_FOUND = 1;

		FCP_SET(B, A, 0x4, 0x2, 1);

		FCI_DELAYBYTE_US(10);

		FCD_09c91_FormulaFlowcode1__FF_SampleADC(FCV_09c91_FormulaFlowcode1__ADC_IRF);

		FCP_SET(B, A, 0x4, 0x2, 0);

		FCL_THRESH = 100;

	// } else {

	}

	if ((FCL_SENSOR == 2) || (FCL_SENSOR == 'r') || (FCL_SENSOR == 'R'))
	{

		FCL_FOUND = 1;

		FCP_SET(B, A, 0x10, 0x4, 1);

		FCI_DELAYBYTE_US(10);

		FCD_09c91_FormulaFlowcode1__FF_SampleADC(FCV_09c91_FormulaFlowcode1__ADC_IRR);

		FCP_SET(B, A, 0x10, 0x4, 0);

		FCL_THRESH = 100;

	// } else {

	}

	if (FCL_FOUND)
	{

		FCR_RETVAL = FCD_09c91_FormulaFlowcode1__FF_ReadADC();

		if (FCL_THRESH > FCR_RETVAL)
		{

			FCR_RETVAL = 1;

		} else {

			FCR_RETVAL = 0;

		}

	} else {

		FCR_RETVAL = 0;

	}

	return (FCR_RETVAL);

}

/*=----------------------------------------------------------------------=*\
   Use :Renvoie : MX_UINT16
\*=----------------------------------------------------------------------=*/
MX_UINT16 FCD_09c91_FormulaFlowcode1__FF_ReadADC()
{
	//Dfinitions des variables locales
	MX_UINT16 FCR_RETVAL;


	#if (0) // 0 == 1

	//Le code a t optimis par le prprocesseur
	#else

		FCR_RETVAL = adresh & 0xFF;

	#endif

	return (FCR_RETVAL);

}

/*=----------------------------------------------------------------------=*\
   Use :Reads the analogue value from the specified IR distance sensor.
       :
       :Param??tres pour la macro ReadIRSensor :
       :  Sensor : MX_UINT8
       :
       :Renvoie : MX_UINT16
\*=----------------------------------------------------------------------=*/
MX_UINT16 FCD_09c91_FormulaFlowcode1__ReadIRSensor(MX_UINT8 FCL_SENSOR)
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_FOUND = (0x0);
	MX_UINT16 FCR_RETVAL;


	porta = 0x00;

	trisa = 0x2A;

	if ((FCL_SENSOR == 0) || (FCL_SENSOR == 'l') || (FCL_SENSOR == 'L'))
	{

		FCL_FOUND = 1;

		FCP_SET(B, A, 0x1, 0x0, 1);

		FCI_DELAYBYTE_US(10);

		FCD_09c91_FormulaFlowcode1__FF_SampleADC(FCV_09c91_FormulaFlowcode1__ADC_IRL);

		FCP_SET(B, A, 0x1, 0x0, 0);

	// } else {

	}

	if ((FCL_SENSOR == 1) || (FCL_SENSOR == 'f') || (FCL_SENSOR == 'F'))
	{

		FCL_FOUND = 1;

		FCP_SET(B, A, 0x4, 0x2, 1);

		FCI_DELAYBYTE_US(10);

		FCD_09c91_FormulaFlowcode1__FF_SampleADC(FCV_09c91_FormulaFlowcode1__ADC_IRF);

		FCP_SET(B, A, 0x4, 0x2, 0);

	// } else {

	}

	if ((FCL_SENSOR == 2) || (FCL_SENSOR == 'r') || (FCL_SENSOR == 'R'))
	{

		FCL_FOUND = 1;

		FCP_SET(B, A, 0x10, 0x4, 1);

		FCI_DELAYBYTE_US(10);

		FCD_09c91_FormulaFlowcode1__FF_SampleADC(FCV_09c91_FormulaFlowcode1__ADC_IRR);

		FCP_SET(B, A, 0x10, 0x4, 0);

	// } else {

	}

	if (FCL_FOUND)
	{

		FCR_RETVAL = FCD_09c91_FormulaFlowcode1__FF_ReadADC();

	} else {

		FCR_RETVAL = 0;

	}

	return (FCR_RETVAL);

}

/*=----------------------------------------------------------------------=*\
   Use :Sets the speed and direction of the Formula Flowcode motors.
       :
       :Param??tres pour la macro SetMotors :
       :  Left_Power : Valid Range = -255 to 255
       :  Right_Power : Valid Range = -255 to 255
\*=----------------------------------------------------------------------=*/
void FCD_09c91_FormulaFlowcode1__SetMotors(MX_SINT16 FCL_LEFT_POWER, MX_SINT16 FCL_RIGHT_POWER)
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_MOTOR_LEFT;
	MX_UINT8 FCL_MOTOR_RIGHT;
	MX_UINT16 FCL_POWER;
	MX_UINT8 FCL_SCALEFACTOR;
	MX_UINT16 FCL_SCALEDVAL;


	trise = trise & 0xFC;

	porte = porte & 0xFC;

	if (FCL_LEFT_POWER < 0)
	{

		FCL_POWER = 0 - FCL_LEFT_POWER;

	} else {

		FCL_POWER = FCL_LEFT_POWER;

	}

	if (FCL_POWER > 255)
	{

		FCL_POWER = 255;

	// } else {

	}

	#if (0) // 0 < 0

	//Le code a t optimis par le prprocesseur
	// #else

	#endif

	if (FCL_LEFT_POWER > 0)
	{

		FCP_SET(B, E, 0x1, 0x0, 1);
		FCL_MOTOR_LEFT = 255 - FCL_POWER;

	} else {

		FCL_MOTOR_LEFT = FCL_POWER;

	}

	if (FCL_RIGHT_POWER < 0)
	{

		FCL_POWER = 0 - FCL_RIGHT_POWER;

	} else {

		FCL_POWER = FCL_RIGHT_POWER;

	}

	if (FCL_POWER > 255)
	{

		FCL_POWER = 255;

	// } else {

	}

	#if (0) // 0 > 0

	//Le code a t optimis par le prprocesseur
	// #else

	#endif

	if (FCL_RIGHT_POWER > 0)
	{

		FCP_SET(B, E, 0x2, 0x1, 1);
		FCL_MOTOR_RIGHT = 255 - FCL_POWER;

	} else {

		FCL_MOTOR_RIGHT = FCL_POWER;

	}

	FCD_09c91_FormulaFlowcode1__FF_SetDutyCycle(FCL_MOTOR_LEFT, FCL_MOTOR_RIGHT);

}

/*=----------------------------------------------------------------------=*\
   Use :Drives both motors of the formula flowcode backwards with the power specified.
       :
       :Param??tres pour la macro Reverse :
       :  Power : MX_UINT8
\*=----------------------------------------------------------------------=*/
void FCD_09c91_FormulaFlowcode1__Reverse(MX_UINT8 FCL_POWER)
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_POWER_L;
	MX_UINT8 FCL_POWER_R;
	MX_UINT8 FCL_SCALEFACTOR;
	MX_UINT16 FCL_SCALEVAL;
	MX_UINT16 FCL_BAL;


	trise = trise & 0xFC;

	porte = porte & 0xFC;

	#if (0) // 0 < 0

	//Le code a t optimis par le prprocesseur
	#else

		FCL_POWER_L = FCL_POWER;

	#endif

	#if (0) // 0 > 0

	//Le code a t optimis par le prprocesseur
	#else

		FCL_POWER_R = FCL_POWER;

	#endif

	FCD_09c91_FormulaFlowcode1__FF_SetDutyCycle(FCL_POWER_L, FCL_POWER_R);

}

/*=----------------------------------------------------------------------=*\
   Use :Waits for the specified switch to be pressed.
       :
       :Param??tres pour la macro WaitForSwitch :
       :  Switch : MX_UINT8
\*=----------------------------------------------------------------------=*/
void FCD_09c91_FormulaFlowcode1__WaitForSwitch(MX_UINT8 FCL_SWITCH)
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_WAIT = (0x0);


	if ((FCL_SWITCH == 0) || (FCL_SWITCH == 'l') || (FCL_SWITCH == 'L'))
	{

		while (FCL_WAIT == 0)
		{

			FCL_WAIT = FCP_GET(B, B, 0x20, 0x5);


		}

	} else {

		while (FCL_WAIT == 0)
		{

			FCL_WAIT = FCP_GET(B, B, 0x10, 0x4);


		}

	}

}

/*=----------------------------------------------------------------------=*\
   Use :Reads the current audio signal level from the on-board light sensor.
       :
       :Renvoie : MX_SINT16
\*=----------------------------------------------------------------------=*/
MX_SINT16 FCD_09c91_FormulaFlowcode1__ReadLDR()
{
	//Dfinitions des variables locales
	MX_SINT16 FCR_RETVAL;


	trisb = trisb | 0x08;

	FCD_09c91_FormulaFlowcode1__FF_SampleADC(FCV_09c91_FormulaFlowcode1__ADC_LDR);

	FCR_RETVAL = FCD_09c91_FormulaFlowcode1__FF_ReadADC();

	return (FCR_RETVAL);

}

/*=----------------------------------------------------------------------=*\
   Use :Param??tres pour la macro FF_SetDutyCycle :
       :  DutyL : MX_UINT8
       :  DutyR : MX_UINT8
\*=----------------------------------------------------------------------=*/
void FCD_09c91_FormulaFlowcode1__FF_SetDutyCycle(MX_UINT8 FCL_DUTYL, MX_UINT8 FCL_DUTYR)
{

	ccpr1l = FCL_DUTYL;

	ccpr2l = FCL_DUTYR;

}

/*=----------------------------------------------------------------------=*\
   Use :Allows control of all 8-LEDs on the front of the Formula Flowcode.
       :
       :Param??tres pour la macro WriteLEDs :
       :  LED_Byte : MX_UINT8
\*=----------------------------------------------------------------------=*/
void FCD_09c91_FormulaFlowcode1__WriteLEDs(MX_UINT8 FCL_LED_BYTE)
{

	FCP_SET(F, D, 0xff, 0x0, FCL_LED_BYTE);

}

/*=----------------------------------------------------------------------=*\
   Use :Starts up the formula flowcode PWM for motor control and performs the wait for button press
\*=----------------------------------------------------------------------=*/
void FCD_09c91_FormulaFlowcode1__Initialise()
{
	//Dfinitions des variables locales
	MX_UINT8 FCL_PRESS = (0x0);


	FCP_SET(F, D, 0xff, 0x0, 0);

	#if (0) // 0 == 1

	//Le code a t optimis par le prprocesseur
	// #else

	#endif

	clear_bit(trisc, 2);

	clear_bit(trisc, 1);

	pr2 = 255;

	t2con = 0x04;

	ccpr1l = 0;

	ccpr2l = 0;

	ccp1con = 0x0C;

	ccp2con = 0x0C;



}


/*========================================================================*\
   Use :panel
       :Implmentations de la macro
\*========================================================================*/
/*=----------------------------------------------------------------------=*\
   Use :Lecture des capteurs IR
\*=----------------------------------------------------------------------=*/
void FCM_lire_capteurs_IR()
{

	// Lecture du capteur gauche
	// Appel de la Routine Composant: left=FormulaFlowcode1::ReadIRSensor(0)
	FCV_LEFT = FCD_09c91_FormulaFlowcode1__ReadIRSensor(0);

	// Lecture du capteru avant
	// Appel de la Routine Composant: front=FormulaFlowcode1::ReadIRSensor(1)
	FCV_FRONT = FCD_09c91_FormulaFlowcode1__ReadIRSensor(1);

	// Lecture du capteur droit
	// Appel de la Routine Composant: right=FormulaFlowcode1::ReadIRSensor(2)
	FCV_RIGHT = FCD_09c91_FormulaFlowcode1__ReadIRSensor(2);

}

/*=----------------------------------------------------------------------=*\
   Use :
\*=----------------------------------------------------------------------=*/
void FCM_degagerment()
{

	// Lecture des capteurs IR
	// Appel d'une Macro: lire_capteurs_IR()
	FCM_lire_capteurs_IR();

	// Tant que l'obstacle est  moins de 75
	// Boucle: While front <= 75
	while (FCV_FRONT <= 75)
	{

		// Arret du robot
		// Appel de la Routine Composant: FormulaFlowcode1::Stop()
		FCD_09c91_FormulaFlowcode1__Stop();

		// Extinction des LEDs
		// Appel d'une Macro: eteindre_LEDs()
		FCM_eteindre_LEDs();

		// Allumage led 0
		// Appel de la Routine Composant: FormulaFlowcode1::LEDOn(0)
		FCD_09c91_FormulaFlowcode1__LEDOn(0);

		// Allumage led 7
		// Appel de la Routine Composant: FormulaFlowcode1::LEDOn(7)
		FCD_09c91_FormulaFlowcode1__LEDOn(7);

		// Lecture des capteurs IR
		// Appel d'une Macro: lire_capteurs_IR()
		FCM_lire_capteurs_IR();

		// De quel cot doit on tourner?
		// Dcision: right > left?
		if (FCV_RIGHT > FCV_LEFT)
		{

			// On tourne  droite
			// Appel de la Routine Composant: FormulaFlowcode1::SpinRight(138)
			FCD_09c91_FormulaFlowcode1__SpinRight(138);

			// rotation de ~25
			// Pause: 250 ms
			FCI_DELAYBYTE_MS(250);

			// Arret du robot
			// Appel de la Routine Composant: FormulaFlowcode1::Stop()
			FCD_09c91_FormulaFlowcode1__Stop();

		} else {

			// On tourne  gauche
			// Appel de la Routine Composant: FormulaFlowcode1::SpinLeft(138)
			FCD_09c91_FormulaFlowcode1__SpinLeft(138);

			// rotation de ~25
			// Pause: 250 ms
			FCI_DELAYBYTE_MS(250);

			// Arret du robot
			// Appel de la Routine Composant: FormulaFlowcode1::Stop()
			FCD_09c91_FormulaFlowcode1__Stop();

		}


	}

	// Extinction des LEDs
	// Appel d'une Macro: eteindre_LEDs()
	FCM_eteindre_LEDs();

}

/*=----------------------------------------------------------------------=*\
   Use :initialisation du robot
\*=----------------------------------------------------------------------=*/
void FCM_init()
{

	// Initialisation du robot
	// Appel de la Routine Composant: FormulaFlowcode1::Initialise()
	FCD_09c91_FormulaFlowcode1__Initialise();

	//Commentaire:
	//Attente du bouton de dmarrage dfini par le bouton droit avant

	// Attente du bouton 4 (droite avant)
	// Appel de la Routine Composant: FormulaFlowcode1::WaitForSwitch(4)
	FCD_09c91_FormulaFlowcode1__WaitForSwitch(4);

	// Son de confirmation
	// Appel de la Routine Composant: FormulaFlowcode1::PlayNote(5, 250)
	FCD_09c91_FormulaFlowcode1__PlayNote(5, 250);

}

/*=----------------------------------------------------------------------=*\
   Use :Marche "avant" tant que pas d'obstacle frontal 

       :et correction en temps r??el de la trajectoire 

       :en fonction de la distance des obstacles lat??raux.
\*=----------------------------------------------------------------------=*/
void FCM_marche_libre()
{

	// Lecture des capteurs IR
	// Appel d'une Macro: lire_capteurs_IR()
	FCM_lire_capteurs_IR();

	// Appel d'une Macro
	// Appel d'une Macro: eteindre_LEDs()
	FCM_eteindre_LEDs();

	// Tant que l'obstacle est  plus de 75
	// Boucle: While front > 75
	while (FCV_FRONT > 75)
	{

		// Lecture des capteurs IR
		// Appel d'une Macro: lire_capteurs_IR()
		FCM_lire_capteurs_IR();

		// Si la distance gauche depasse 150
		// Dcision: left > vit?
		if (FCV_LEFT > FCV_VIT)
		{

			// On force la valeur de la distance
			// Calcul:
			//  left = vit
			FCV_LEFT = FCV_VIT;

		// } else {

		}

		// Si la distance droite depasse 150
		// Dcision: right > vit?
		if (FCV_RIGHT > FCV_VIT)
		{

			// On force la valeur de la distance
			// Calcul:
			//  right = vit
			FCV_RIGHT = FCV_VIT;

		// } else {

		}

		// Quantification de la distance gauche et droite
		// Calcul:
		//  compR = vit - right
		//  compL = vit - left
		FCV_COMPR = FCV_VIT - FCV_RIGHT;
		FCV_COMPL = FCV_VIT - FCV_LEFT;

		// Allumage led 3
		// Appel de la Routine Composant: FormulaFlowcode1::LEDOn(3)
		FCD_09c91_FormulaFlowcode1__LEDOn(3);

		// Allumage led 4
		// Appel de la Routine Composant: FormulaFlowcode1::LEDOn(4)
		FCD_09c91_FormulaFlowcode1__LEDOn(4);

		// Controle des moteurs  partr d'un vitesse de base (150) 
		// Appel de la Routine Composant: FormulaFlowcode1::SetMotors(vit + compL - compR, vit + compR - compL)
		FCD_09c91_FormulaFlowcode1__SetMotors(FCV_VIT + FCV_COMPL - FCV_COMPR, FCV_VIT + FCV_COMPR - FCV_COMPL);

		//Commentaire:
		//Dans la macro prcdente:
		//On fait varier la vitesse de chaque roue 
		//individuellement pour ameliorer la linarit 
		//de la trajectoire. 
		//(correction des defaults materiels).
		//La fonction SetMotors ne fonctionne
		//pas en rel pour l'instant.


	}

}

/*=----------------------------------------------------------------------=*\
   Use :
\*=----------------------------------------------------------------------=*/
void FCM_eteindre_LEDs()
{

	// Extinction de la led
	// Appel de la Routine Composant: FormulaFlowcode1::LEDOff(0)
	FCD_09c91_FormulaFlowcode1__LEDOff(0);

	// Extinction de la led
	// Appel de la Routine Composant: FormulaFlowcode1::LEDOff(1)
	FCD_09c91_FormulaFlowcode1__LEDOff(1);

	// Extinction de la led
	// Appel de la Routine Composant: FormulaFlowcode1::LEDOff(2)
	FCD_09c91_FormulaFlowcode1__LEDOff(2);

	// Extinction de la led
	// Appel de la Routine Composant: FormulaFlowcode1::LEDOff(3)
	FCD_09c91_FormulaFlowcode1__LEDOff(3);

	// Extinction de la led
	// Appel de la Routine Composant: FormulaFlowcode1::LEDOff(4)
	FCD_09c91_FormulaFlowcode1__LEDOff(4);

	// Extinction de la led
	// Appel de la Routine Composant: FormulaFlowcode1::LEDOff(5)
	FCD_09c91_FormulaFlowcode1__LEDOff(5);

	// Extinction de la led
	// Appel de la Routine Composant: FormulaFlowcode1::LEDOff(6)
	FCD_09c91_FormulaFlowcode1__LEDOff(6);

	// Extinction de la led
	// Appel de la Routine Composant: FormulaFlowcode1::LEDOff(7)
	FCD_09c91_FormulaFlowcode1__LEDOff(7);

}

//Programme principale du robot


/*========================================================================*\
   Use :Principale
\*========================================================================*/
void main()
{

	adcon0 = 0x3D;
	adcon1 = 0x0F;
	ucfg = 0x08;
	cr_bit(pie2, USBIE);






	//Commentaire:
	//"Init" initialise tous les compostants 
	//et attend que la "course" dmarre.
	//Appuyer/Cliquer sur le bouton SW4
	//pour dmarrer le Buggy.

	// Initialisation du robot 
	// Appel d'une Macro: init()
	FCM_init();

	// Main ( boucle infinie)
	// Boucle: While 1
	while (1)
	{

		// Marche avant tant que pas d'obstacle
		// Appel d'une Macro: marche_libre()
		FCM_marche_libre();

		// Dgagement de l'obstacle
		// Appel d'une Macro: degagerment()
		FCM_degagerment();


	}

	mainendloop: goto mainendloop;
}




/*========================================================================*\
   Use :Interruption
\*========================================================================*/
void MX_INTERRUPT_MACRO(void)
{


}





